capt program drop oneDproj
program define oneDproj, eclass

version 11.0

* This ado file computes the 1-dimensional projection of the identification
* set on various dimensions of the explanatory variables. These dimensions
* are specified in the 'dim' option, which indicates the number of X's to report results on,
* not counting the intercept. The intercept is included by default but can be excluded  
* with the 'nointercept' option.  This program displays the bounds and also saves
* the results that are accessible via ereturn.

syntax varlist (min=2 default=none) [, Dim(integer 0) noINTercept PREDict(namelist min=1 max=1) CONtrast(namelist min=1 max=1)]
tokenize `varlist'

qui {

* Checking Projection Dimension Specification *
local xnum : word count `varlist'
local xnum = `xnum' - 1
capt assert (`dim'+1) <= `xnum'
if _rc != 0 {
	di as error "dimension requested is larger than the dimension of X"
	exit
}

* Create Temporary Intercept Variable and YLow Yhigh Variables *
local 0 = "`1'"
local 1 = "`2'"
tempvar missing constant
gen `missing' = `1' == . | `2' == .
gen `constant' = 1
local 2 = "`constant'"

count if `missing' == 0
local nobs = r(N)

* Calculating the Projection Interval *
if `dim' == 0 {
	local end = `xnum' + 1
}
if `dim' != 0 {
	local end = `dim' + 2
}
local all = `xnum' + 1

if "`intercept'" == "nointercept" {
	local begin = 3
}
if "`intercept'" != "nointercept" {
	local begin = 2
}
matrix define bounds = J((`end'-`begin'+1),2,0)

forvalues i = `begin'/`end' {
	* Form the list of all other variables *
	local rest
	forvalues j = 2/`all' {
		if `i' != `j' {
			* local rest = "`rest'" + " " + "``j''"
			local rest "`rest' ``j''"
		}
	}
	* Residual from a linear regression of X to prject on the other Xs, which includes intercept *
	qui reg ``i'' `rest' if `missing' == 0, noconstant
	tempvar resid set1 set2 min max aggmin aggmax denominator
	predict `resid' if e(sample) == 1, resid
	* Calculate the Projection *
    gen `set1' = `resid'*`0'
	gen `set2' = `resid'*`1'
	egen `min' = rowmin(`set1' `set2')
	egen `max' = rowmax(`set1' `set2')
	egen `aggmin' = total(`min')
    egen `aggmax' = total(`max')
    egen `denominator' = total(`resid'^2)
    * Projection Interval *
	local k = `i' - 2
	local lb_`k' = `aggmin'[1]/`denominator'[1]
	local ub_`k' = `aggmax'[1]/`denominator'[1]
	if "`intercept'" != "nointercept" {
		matrix bounds[`k'+1,1] = `aggmin'[1]/`denominator'[1] 
		matrix bounds[`k'+1,2] = `aggmax'[1]/`denominator'[1] 	
	}	
	if "`intercept'" == "nointercept"  {
		matrix bounds[`k',1] = `aggmin'[1]/`denominator'[1] 
		matrix bounds[`k',2] = `aggmax'[1]/`denominator'[1] 	
	}
	noi disp ""
	noi disp "Bounds for Parameter `k' = [lb_`k' , ub_`k']= [" `aggmin'[1]/`denominator'[1] " , " `aggmax'[1]/`denominator'[1] "]"
}

local rows = rowsof(bounds) - 1
ereturn clear

** Find BLP **
if "`predict'" != "" {
	* di as error "Note: Covariate values for prediction must be ordered as list of covariates for oneDproj"
	confirm matrix `predict'
	if _rc != 0 {
		di as error "Covariate values for prediction is not defined as a matrix"
		exit
	}
	matrix ZZZZZ = `predict'
	capture assert colsof(ZZZZZ) == 1
	if _rc != 0 {
		di as error "Covariate prediction set has incorrect dimensions, please provide a `rows'x1 matrix"
		exit
	}	
	capture assert rowsof(ZZZZZ) == `rows'
	if _rc != 0 {
		di as error "Covariate prediction set has incorrect dimensions, please provide a `rows'x1 matrix"
		exit
	}
	
	mata y_lower = st_data(., "`0'") 
	mata y_upper = st_data(., "`1'")
	local rest
	forvalues j = 2/`all' {
		* local rest = "`rest'" + " " + "``j''"
		local rest "`rest' ``j''"
	}
	mata x = st_data(.,"`rest'")
	mata xy_lower = x :* y_lower
	mata xy_upper = x :* y_upper

	corr `rest' if `missing' == 0, cov
	matrix Sigma_Hat = r(C)
	return clear
	mata Sigma_Hat = st_matrix("Sigma_Hat")
	mata ext = mean(x)							/*1xk*/
	mata ex = ext'								/*kx1*/	
	mata mean = ex * ext						/*kxk*/
	mata Sigma_Hat = Sigma_Hat + mean
	
	matrix x0 = 1 , ZZZZZ'
	mata x0 = st_matrix("x0")					/*1xk*/
	mata xSig = x0 * invsym(Sigma_Hat)			/*1xk*/
	matrix drop Sigma_Hat ZZZZZ x0

	mata prod_l = xSig * xy_lower'				/*1xn*/
	mata prod_u = xSig * xy_upper'				/*1xn*/
	mata prod = prod_l' , prod_u'
	mata prod1 = rowmin(prod)
	mata prod1 = colsum(prod1)/`nobs'
	mata prod2 = rowmax(prod)
	mata prod2 = colsum(prod2)/`nobs'
	
	mata st_numscalar("BLP_l",prod1)
	mata st_numscalar("BLP_u",prod2)
	ereturn scalar BLP_l = BLP_l 
	ereturn scalar BLP_u = BLP_u
	mata mata drop prod prod1 prod2 prod_l prod_u x0 xSig Sigma_Hat mean ex ext x xy_lower xy_upper y_lower y_upper
	
	noi disp ""
	noi disp "BLP Bounds = [BLP_l , BLP_u] = [" e(BLP_l) " , " e(BLP_u) "]" 
}

** Find BLP Contrasts**
if "`contrast'" != "" {

	confirm matrix `contrast'
	if _rc != 0 {
		di as error "Covariate values for contrast prediction is not defined as a matrix"
		exit
	}
	matrix ZZZZZ = `contrast'
	capture assert colsof(ZZZZZ) == 2
	if _rc != 0 {
		di as error "Covariate prediction set has incorrect dimensions, please provide a `rows'x2 matrix"
		exit
	}	
	capture assert rowsof(ZZZZZ) == `rows'
	if _rc != 0 {
		di as error "Covariate prediction set has incorrect dimensions, please provide a `rows'x2 matrix"
		exit
	}
	
	mata y_lower = st_data(., "`0'") 
	mata y_upper = st_data(., "`1'")
	local rest
	forvalues j = 2/`all' {
		* local rest = "`rest'" + " " + "``j''"
		local rest "`rest' ``j''"
	}
	mata x = st_data(.,"`rest'")
	mata xy_lower = x :* y_lower
	mata xy_upper = x :* y_upper

	corr `rest' if `missing' == 0, cov
	matrix Sigma_Hat = r(C)
	return clear
	mata Sigma_Hat = st_matrix("Sigma_Hat")
	mata ext = mean(x)							/*1xk*/
	mata ex = ext'								/*kx1*/	
	mata mean = ex * ext						/*kxk*/
	mata Sigma_Hat = Sigma_Hat + mean
	
	matrix x0 = [1\1] , ZZZZZ'
	mata x0 = st_matrix("x0")					/*2xk*/
	mata x0 = x0[1,] - x0[2,]					/*1xk*/
	mata xSig = x0 * invsym(Sigma_Hat)			/*1xk*/
	matrix drop Sigma_Hat ZZZZZ x0

	mata prod_l = xSig * xy_lower'				/*1xn*/
	mata prod_u = xSig * xy_upper'				/*1xn*/
	mata prod = prod_l' , prod_u'
	mata prod1 = rowmin(prod)
	mata prod1 = colsum(prod1)/`nobs'
	mata prod2 = rowmax(prod)
	mata prod2 = colsum(prod2)/`nobs'
	
	mata st_numscalar("BLP_con_l",prod1)
	mata st_numscalar("BLP_con_u",prod2)
	ereturn scalar BLP_con_l = BLP_con_l 
	ereturn scalar BLP_con_u = BLP_con_u
	mata mata drop prod prod1 prod2 prod_l prod_u x0 xSig Sigma_Hat mean ex ext x xy_lower xy_upper y_lower y_upper
	
	noi disp ""
	noi disp "BLP Contrast Bounds = [BLP_con_l , BLP_con_u] = [" e(BLP_con_l) " , " e(BLP_con_u) "]" 
}

ereturn matrix Thetahat1D = bounds
if "`predict'" != "" {
	matrix ZZ = [e(BLP_l),e(BLP_u)]
	ereturn matrix ThetahatPred = ZZ
}
if "`contrast'" != "" {
	matrix ZZ = [e(BLP_con_l),e(BLP_con_u)]
	ereturn matrix ThetahatPredCon = ZZ
}
forvalues i = `begin'/`end' {
	local k = `i' - 2
	ereturn scalar lb_`k' = `lb_`k''
	ereturn scalar ub_`k' = `ub_`k''
}

}

end
